/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.dialogs;

import de.willuhn.jameica.backup.BackupFile;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.internal.parts.BackupVersionsList;
import de.willuhn.jameica.gui.util.ButtonArea;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import org.eclipse.swt.widgets.Composite;

public class BackupRestoreDialog
extends AbstractDialog {
    private BackupFile backup = null;
    private Boolean choice = Boolean.FALSE;

    public BackupRestoreDialog(int position, BackupFile backup) {
        super(position);
        this.backup = backup;
        this.setSize(470, 400);
        this.setTitle(Application.getI18n().tr("Backup wiederherstellen?"));
    }

    protected Object getData() throws Exception {
        return this.choice;
    }

    @Override
    protected void paint(Composite parent) throws Exception {
        SimpleContainer container = new SimpleContainer(parent, true);
        container.addHeadline(Application.getI18n().tr("Enthaltene Plugins im Backup"));
        BackupVersionsList table = new BackupVersionsList(this.backup);
        table.paint(container.getComposite());
        if (table.hasWarnings()) {
            container.addText(Application.getI18n().tr("Die Benutzerdaten des Backup passen nicht exakt zu den Versionen der installierten Plugins. Unter Umst\u00e4nden werden nicht alle Daten aus dem Backup wiederhergestellt."), true, Color.ERROR);
        }
        container.addHeadline(Application.getI18n().tr("Achtung"));
        container.addText(Application.getI18n().tr("Sind Sie sicher, dass Sie dieses Backup wiederherstellen m\u00f6chten?\nDie Anwendung wird daraufhin beendet, die Wiederherstellung erfolgt automatisch beim n\u00e4chsten Start."), true);
        ButtonArea buttons = container.createButtonArea(2);
        buttons.addButton(Application.getI18n().tr("Ja, Backup wiederherstellen"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                BackupRestoreDialog.this.choice = Boolean.TRUE;
                BackupRestoreDialog.this.close();
            }
        }, null, false, "ok.png");
        buttons.addButton(Application.getI18n().tr("Nein, Vorgang abbrechen"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                BackupRestoreDialog.this.choice = Boolean.FALSE;
                BackupRestoreDialog.this.close();
            }
        }, null, true, "process-stop.png");
    }
}

